<?php
/**
*  Plugin
*  DefaultEditor V1.0
*  Copyright © 2010 Edson Ordaz
*
*  Website: http://www.mybb-es.com
*  MyBB-Es Team!
*/
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook("newthread_end", "DefaultEditor");
$plugins->add_hook("admin_load", "DefaultEditor_admin");
$plugins->add_hook("admin_forum_menu", "DefaultEditor_admin_nav");
$plugins->add_hook("admin_forum_action_handler", "DefaultEditor_action_handler");

function DefaultEditor_info()
{
	return array(
		"name"			=> "هاك العنوان والرسالة الافتراضي بالمحرر",
		"description"	=> "يسمح لك باضافة عنوان ورساله افتراضية تظهر بالمحرر علي حسب كل قسم",
		"website"		=> "mailto:nicedo_eeos@hotmail.com",
		"author"		=> "Edson Ordaz",
		"authorsite"	=> "mailto:nicedo_eeos@hotmail.com",
		"version"		=> "<b>1.0</b>",
		"compatibility" => "16*",
		"guid"			=> "94daf3119149a9cda5a0153ae42e70a6"
	);

}

function DefaultEditor_activate(){
	global $db;
	$db->query("ALTER TABLE `".TABLE_PREFIX."forums` ADD `defaulttitle` TEXT NULL AFTER `defaultsortorder`");
	$db->query("ALTER TABLE `".TABLE_PREFIX."forums` ADD `defaultmessage` TEXT NULL AFTER `defaulttitle`");
}

function DefaultEditor_deactivate(){
	global $db;
    $db->query("ALTER TABLE ".TABLE_PREFIX."forums DROP `defaulttitle`");
    $db->query("ALTER TABLE ".TABLE_PREFIX."forums DROP `defaultmessage`");
}

function DefaultEditor_action_handler(&$action)
{
	$action['default_editor'] = array('active' => 'default_editor', 'file' => '');
}

function DefaultEditor_admin_nav(&$sub_menu)
{
	global $mybb, $lang;
		$lang->load("forum_defaulteditor", false, true);
		end($sub_menu);
		$key = (key($sub_menu))+10;
		
		if(!$key)
		{
			$key = '110';
		}
		
		$sub_menu[$key] = array('id' => $lang->Url, 'title' => $lang->Name, 'link' => "index.php?module=forum/default_editor");

}


function DefaultEditor_admin()
{
	global $mybb, $db, $page, $cache, $lang;

	if($page->active_action != $lang->Url)
	{

		return;
	}

	$forum_cache = cache_forums();

	$page->add_breadcrumb_item($lang->Name);
	$page->output_header($lang->Name);

if($mybb->input['action'] == "save") {

	$df = array(
		"defaulttitle" => $db->escape_string($mybb->input['df'])
	);
	$dm = array(
		"defaultmessage" => $db->escape_string($mybb->input['dm'])
	);

	$db->update_query("forums", $df,"fid='{$mybb->input['fid']}'");
	$db->update_query("forums", $dm,"fid='{$mybb->input['fid']}'");
	$cache->update_forums();

		flash_message($lang->saved, 'success');
		admin_redirect("index.php?module=forum/default_editor");

}


if($mybb->input['action'] == "edit") {


	$form = new Form("index.php?module=forum/default_editor&amp;action=save", "post");
	echo $form->generate_hidden_field("fid", $mybb->input['fid']);
	$form_container = new FormContainer($forum_cache[$mybb->input['fid']]['name']);

	$form_container->output_row($lang->title, $lang->titledescription, $form->generate_text_box('df', $forum_cache[$mybb->input['fid']]['defaulttitle'], array('id' => 'df')), 'df');
	$form_container->output_row($lang->Message, $lang->Messagedescription, $form->generate_text_area('dm', $forum_cache[$mybb->input['fid']]['defaultmessage'], array('id' => 'dm')), 'dm');
	$form_container->end();

	$buttons[] = $form->generate_submit_button($lang->submit);
	$form->output_submit_wrapper($buttons);
	$form->end();
}

echo "<p class=\"notice\"><b>تقوم هنا بتحديد الرسالة والعنوان الافتراضية الخاصه بكل قسم </b></p>";

		$table = new Table;

		$table->construct_header($lang->forum, array("width" => "25%"));
		$table->construct_header($lang->defaulttitle, array("class" => "align_center", "width" => "34%"));
		$table->construct_header($lang->defaultmessage, array("class" => "align_center", "width" => "34%"));
		$table->construct_header($lang->options, array("class" => "align_center", "width" => "7%"));
		$table->construct_row();


		foreach($forum_cache as $forum)
		{

			if($forum['type'] != "c")
			{
				$table->construct_cell("<b>".$forum['name']."</b>");
				$table->construct_cell("<center>".$forum['defaulttitle']."</center>");
				$table->construct_cell("<center>".$forum['defaultmessage']."</center>");
				$table->construct_cell("<a href=\"index.php?module=forum/default_editor&amp;action=edit&amp;fid={$forum['fid']}\">{$lang->edit}</a>", array("class" => "align_center"));

			}

		$table->construct_row();

		}

		$table->output($lang->forums);

		$page->output_footer();

}

function DefaultEditor()
{
	global $mybb, $thread_errors, $forum, $message, $post, $subject;
	if($mybb->input['action'] == "editdraft" || $mybb->input['previewpost'] || $mybb->input['attachmentaid'] || $mybb->input['newattachment'] || $thread_errors)
	{
		return;
	}
	$message = $forum['defaultmessage'];
	$subject = $forum['defaulttitle'];

}
?>